<?php

namespace Dhii\Exception;

use Exception as RootException;

abstract class AbstractBaseException extends RootException implements ThrowableInterface
{
    /* Functionality common to exceptions
     *
     * @since [*next-version*]
     */
    use ExceptionTrait;

    /**
     * Calls the parent constructor.
     *
     * @param string        $message  The error message.
     * @param int           $code     The error code.
     * @param RootException $previous The inner exception, if any.
     *
     * @since [*next-version*]
     */
    protected function _initParent($message = '', $code = 0, RootException $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    /**
     * Parameter-less constructor.
     *
     * Invoke this in actual constructor.
     *
     * @since [*next-version*]
     */
    protected function _construct()
    {
    }
}
