/**
 * API Football Frontend Scripts
 */

(function($) {
    'use strict';
    
    // Translation strings (localized via wp_localize_script)
    var l10n = window.apiFootballL10n || {};
    
    $(document).ready(function() {
        // Initialize API Football widgets
        initApiFootballWidgets();
    });
    
    function initApiFootballWidgets() {
        // Add responsive table wrapper
        $('.api-football-table').each(function() {
            if (!$(this).parent().hasClass('table-responsive')) {
                $(this).wrap('<div class="table-responsive"></div>');
            }
        });
        
        // Add data labels for mobile responsive tables
        $('.api-football-table').each(function() {
            var $table = $(this);
            var headers = [];
            
            // Get headers
            $table.find('thead th').each(function() {
                headers.push($(this).text());
            });
            
            // Add data labels to cells
            $table.find('tbody tr').each(function() {
                $(this).find('td').each(function(index) {
                    if (headers[index]) {
                        $(this).attr('data-label', headers[index]);
                    }
                });
            });
        });
        
        // Lazy load team logos
        if ('IntersectionObserver' in window) {
            var imageObserver = new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var img = entry.target;
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                        imageObserver.unobserve(img);
                    }
                });
            });
            
            document.querySelectorAll('.team-logo.lazy').forEach(function(img) {
                imageObserver.observe(img);
            });
        }
    }
    
    // Add table responsive wrapper styles
    if (!document.querySelector('style[data-api-football-responsive]')) {
        var style = document.createElement('style');
        style.setAttribute('data-api-football-responsive', '');
        style.textContent = `
//             .table-responsive {
//                 overflow-x: auto;
//                 -webkit-overflow-scrolling: touch;
//             }
            .team-logo.lazy {
                opacity: 0.5;
                transition: opacity 0.3s;
            }
            .team-logo:not(.lazy) {
                opacity: 1;
            }
        `;
        document.head.appendChild(style);
    }
    
})(jQuery); 

document.addEventListener('DOMContentLoaded', () => {
    // Get all span elements by their class name
    const targetSpans = document.querySelectorAll('.form-string');

    // Check if any span elements exist
    if (targetSpans.length > 0) {
        // Iterate over each target span
        targetSpans.forEach(targetSpan => {
            // Get the original text content of the span
            const originalText = targetSpan.textContent;
            let newHtmlContent = '';

            // Iterate over each character in the original text
            for (let i = 0; i < originalText.length; i++) {
                const char = originalText[i];
                let color = ''; // Variable to hold the background color

                // Determine the color based on the character
                switch (char.toUpperCase()) {
                    case 'D':
                        color = '#ffa800';
                        break;
                    case 'W':
                        color = '#01d099';
                        break;
                    case 'L':
                        color = '#f64e60';
                        break;
                    default:
                        // If the character is not D, W, or L, no special styling is applied
                        break;
                }

                // If a color is determined, wrap the character in a styled span
                if (color) {
                    newHtmlContent += `<span style="background-color: ${color}; padding: 2px 4px;">${char}</span>`;
                } else {
                    // If no color, just add the character as is
                    newHtmlContent += char;
                }
            }

            // Update the innerHTML of the current target span with the new styled content
            targetSpan.innerHTML = newHtmlContent;
        });
    } else {
        console.error('Span(s) with class "form-string" not found.');
    }
});